<?php

namespace App\Reporting;

use App\Contracts\ReportTile;

class MostPopularBrandTile extends ReportTile
{
    public function name(): string
    {
        return 'Most popular brand';
    }

    public function value(): mixed
    {
        return 'Audi';
    }

    public function difference(): mixed
    {
        return '33%';
    }

    public function secondaryValue(): mixed
    {
        return 1227;
    }

    public function subtitle(): string
    {
        return 'last 30 days';
    }

    public function differenceType(): string
    {
        if ($this->difference() > 0) {
            return 'positive';
        }
        return $this->difference() < 0
            ? 'negative'
            : 'noChange';
    }

    public function secondaryValueName(): string
    {
        return 'prev 30 d.';
    }
}
