<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CapLookupSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'CAP',
                'name' => 'Enabled',
                'config_key' => 'lookup-cap-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'CAP',
                'name' => 'Subscriber Id',
                'config_key' => 'lookup-cap-subscriber_id',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'CAP',
                'name' => 'Password',
                'config_key' => 'lookup-cap-password',
                'type' => 'secret',
                'min_tier' => 'pro',
                'value' => '',
            ],
        ];
    }
}
