<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class EasiChatExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'EasiChat',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-easichat-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => $this->getDescription(),
            ],
        ];
    }

    private function getDescription()
    {
        return 'Stock export for EasiChat. '
            . 'When enabled, will grant access to URL for generating/downloading a feed directly from the browser<br/>'
            . 'GET ' . route('tenant.feeds.easichat', [
                'tenant' => tenant('id'),
                'api_token' => config('auth.api_auth_token')])
            . ' to display current vehicles on site<br/><br/>

            To download, append &download=true to the URL
            ';
    }

}
