<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleUsedConditionIncludeExDemoSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Vehicle Used Condition includes Ex-Demo',
                'config_key' => 'automotive-vehicle-filters-used-includes-ex-demo',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'standard',
                'description' => 'When enabled Used condition will also include Ex-Demo vehicles'
            ],
        ];
    }
}
