<?php

namespace App\Reporting\StatsModels;

use App\Contracts\StatsModel;
use Carbon\Carbon;
use Mtc\MercuryDataModels\Vehicle;

class AvgVehicleAge implements StatsModel
{
    /**
     * @return string
     */
    public function getKey(): string
    {
        return 'vehicle-age';
    }

    /**
     * @param Carbon $date
     * @return int
     */
    public function getValue(Carbon $date): mixed
    {
        return Vehicle::query()
            ->active()
            ->average('manufacture_year');
    }
}
