<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PinnedItemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource = $this->resource
            ->map(fn($pinnedItem) => [
                'id' => $pinnedItem->id,
                'title' => $pinnedItem->title,
                'section' => $pinnedItem->subtitle,
                'link' => $pinnedItem->pinned_url,
                'icon' => $this->categoryToIcon($pinnedItem->category),
            ]);
        return parent::toArray($request);
    }

    private function categoryToIcon(?string $category): ?string
    {
        return match ($category) {
            'content' => 'file-lines',
            'menus' => 'code-branch',
            'templates' => 'pen-ruler',
            'global' => 'file-lock',
            'vehicles' => 'cars',
            'offers' => 'badge-dollar',
            'dealerships' => 'location-dot',
            default => null,
        };
    }
}
