<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealerWebEndpointSettingSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Dealer Web Endpoint',
                'config_key' => 'dealerweblms-endpoint',
                'type' => 'string',
                'value' => '',
                'description' => 'Dealer Web LMS endpoint',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Fallback Dealerweb Dealer',
                'config_key' => 'dealerweblms-fallback-dealerweb-dealer',
                'type' => 'string',
                'value' => '',
                'description' => 'Fallback Dealerweb Dealer ID',
            ],
        ];
    }
}
