<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\ContentManager\Models\MediaUse;
use Mtc\MercuryDataModels\Vehicle;

class VehicleExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Vehicle::query()
            ->with([
                'make',
                'model',
                'fuelType',
                'bodyStyle',
                'drivetrain',
                'transmission',
                'mediaUses.media',
                'dealership',
                'features',
            ])
            ->latest()
            ->limit(5000)
            ->get()
            ->map(fn(Vehicle $vehicle) => [
                'slug' => $vehicle->slug,
                'title' => $vehicle->title,
                'derivative' => $vehicle->derivative,
                'registration_number' => $vehicle->registration_number,
                'vin' => $vehicle->vin,
                'auto_trader_id' => $vehicle->auto_trader_id,
                'cap_id' => $vehicle->cap_id,
                'type' => $vehicle->type,
                'is_published' => $vehicle->is_published,
                'is_new' => $vehicle->is_new,
                'is_demo' => $vehicle->is_demo,
                'is_sold' => $vehicle->is_sold,
                'is_reserved' => $vehicle->is_sold,
                'featured' => $vehicle->featured,
                'dealership' => $vehicle->dealership?->name,
                'make' => $vehicle->make?->name,
                'model' => $vehicle->model?->name,
                'fuel_type' => $vehicle->fuelType?->name,
                'body_style' => $vehicle->bodyStyle?->name,
                'drivetrain' => $vehicle->drivetrain?->name,
                'transmission' => $vehicle->transmission?->name,
                'colour' => $vehicle->colour,
                'door_count' => $vehicle->door_count,
                'seats' => $vehicle->seats,
                'engine_size_cc' => $vehicle->engine_size_cc,
                'odometer_mi' => $vehicle->odometer_mi,
                'manufacture_year' => $vehicle->manufacture_year,
                'previous_owner_count' => $vehicle->previous_owner_count,
                'price' => $vehicle->price,
                'monthly_price' => $vehicle->monthly_price,
                'monthly_cost_type' => $vehicle->monthly_cost_type,
                'rrp_price' => $vehicle->rrp_price,
                'deposit' => $vehicle->deposit,
                'features' => $vehicle->features->pluck('name')->implode('|'),
                'images' => $vehicle->mediaUses
                    ->filter(fn($mediaUse) => $mediaUse->media)
                    ->map(fn(MediaUse $mediaUse) => $mediaUse->getUrl('large'))->implode('|'),
                'main_video_url' => $vehicle->main_video_url,
                'exterior_video_url' => $vehicle->exterior_video_url,
                'interior_video_url' => $vehicle->interior_video_url,

            ]);
    }

    /**
     * Export file heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'slug',
            'title',
            'derivative',
            'registration_number',
            'vin',
            'auto_trader_id',
            'cap_id',
            'type',
            'is_published',
            'is_new',
            'is_demo',
            'is_sold',
            'is_reserved',
            'featured',
            'dealership',
            'make',
            'model',
            'fuel_type',
            'body_style',
            'drivetrain',
            'transmission',
            'colour',
            'door_count',
            'seats',
            'engine_size_cc',
            'odometer_mi',
            'manufacture_year',
            'previous_owner_count',
            'price',
            'monthly_price',
            'monthly_cost_type',
            'rrp_price',
            'deposit',
            'features',
            'images',
            'main_video_url',
            'exterior_video_url',
            'interior_video_url',
        ];
    }
}
