<?php

namespace Database\Factories\Master\Models;

use App\Master\Models\ApiToken;
use App\Master\Models\ApiUser;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class ApiUserFactory extends Factory
{
    protected $model = ApiUser::class;

    public function definition(): array
    {
        $tokenTypes = [
            ApiToken::TYPE_OAUTH,
            ApiToken::TYPE_PERSISTENT
        ];

        return [
            'name' => $this->faker->name,
            'is_active' => true,
            'client_id' => Str::slug($this->faker->unique()->word . Str::random(8)),
            'client_secret' => encrypt(Str::random(16)),
            'token_type' => $this->faker->randomElement($tokenTypes),
            'credentials_last_updated_at' => Carbon::now(),
            'credentials_due_for_update_at' => Carbon::now()->addDays(30),
            'notes' => $this->faker->optional()->sentence,
        ];
    }

    public function inactive(): Factory
    {
        return $this->state(fn(array $attributes) => [
            'is_active' => false,
        ]);
    }

    public function oauth(): Factory
    {
        return $this->state(fn(array $attributes) => [
            'token_type' => ApiToken::TYPE_OAUTH,
        ]);
    }

    public function persistent(): Factory
    {
        return $this->state(fn(array $attributes) => [
            'token_type' => ApiToken::TYPE_PERSISTENT,
        ]);
    }
}
