<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BCALookupSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'BCA',
                'name' => 'Enabled',
                'config_key' => 'lookup-bca-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'BCA',
                'name' => 'Api Key',
                'config_key' => 'lookup-bca-api_key',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.lookup-bca-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Lookup',
                'group' => 'BCA',
                'name' => 'Api Secret',
                'config_key' => 'lookup-bca-api_secret',
                'type' => 'secret',
                'min_tier' => 'pro',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.lookup-bca-enabled,true"
                ]
            ],
        ];
    }
}
