<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class KeyloopRev8SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Keyloop Rev8',
                'name' => 'Enabled',
                'config_key' => 'stock-keyloop-rev8-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => 'Retrieve stock through FTP that is passed from Keyloop Rev8',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Keyloop Rev8',
                'name' => 'Only import vehicles with price set',
                'config_key' => 'stock-keyloop-rev8-sync-with-price',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Keyloop Rev8',
                'name' => 'FTP Username',
                'config_key' => 'stock-keyloop-rev8-ftp-username',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'FTP Username for ftp.getautonomy.co.uk'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Keyloop Rev8',
                'name' => 'FTP Password',
                'config_key' => 'stock-keyloop-rev8-ftp-password',
                'type' => 'secret',
                'superadmin' => true,
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'FTP Password for ftp.getautonomy.co.uk'
            ],
        ];
    }
}
