<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OpenAISeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'Open AI',
                'name' => 'Open AI API Key',
                'config_key' => 'open-ai-api_key',
                'min_tier' => 'pro',
                'type' => 'secret',
                'value' => '',
            ],
        ];
    }
}
