<?php

namespace Tests\Tenant;

use App\ReportTypes\OfferReport;
use App\ReportTypes\VehicleReport;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TenantTestCase;

class ReportTypeTest extends TenantTestCase
{
    public function testVehicleReport()
    {
        $this->assertIsString((new VehicleReport())->name());
        $columns = (new VehicleReport())->columns();
        $this->assertIsArray($columns);
        $this->assertArrayHasKey('vin', $columns);
        $this->assertArrayHasKey('mpg', $columns);
        $this->assertArrayHasKey('derivative', $columns);
        $this->assertArrayHasKey('cap_id', $columns);
        $this->assertArrayHasKey('auto_trader_id', $columns);

        $vehicle = Vehicle::factory()->create();
        $query = (new VehicleReport())->query();
        $this->assertTrue($vehicle->is($query->first()));
    }

    public function testOfferReport()
    {
        $this->assertIsString((new OfferReport())->name());
        $columns = (new OfferReport())->columns();
        $this->assertIsArray($columns);
        $this->assertArrayHasKey('slug', $columns);
        $this->assertArrayHasKey('price', $columns);
        $this->assertArrayHasKey('name', $columns);

        $offer = VehicleOffer::factory()->create();
        $query = (new OfferReport())->query();
        $this->assertTrue($offer->is($query->first()));
    }
}
