<?php

namespace App\Actions\IntegrationVerification;

use App\Modules\Stock\DMSNavigator;

class VerifyDmsNavigator
{
    public function __construct(private DMSNavigator $provider)
    {
        //
    }

    public function verify()
    {
        if ($this->ableToRetrieveVehicles() === false) {
            return response([
                'message' => __('integrations.unable_to_connect', ['dealer' => 'Pinewood']),
            ], 422);
        }

        return true;
    }

    private function ableToRetrieveVehicles(): bool
    {
        return $this->provider->fetchVehicles($this->provider->endpoint())->isNotEmpty();
    }
}
