<?php

namespace App\Http\Controllers;

use App\Http\Requests\AutoTraderHubNotification;
use App\Jobs\HandleAutoTraderHubNotification;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\ApiNotification;
use Mtc\MercuryDataModels\Vehicle;

class AutoTraderHubNotificationController extends Controller
{
    use DispatchesJobs;

    public function store(AutoTraderHubNotification $request)
    {
        $vehicle = Vehicle::query()->find($request->input('vehicle_id', 0));
        $apiNotification = ApiNotification::query()
            ->create([
                'provider' => 'auto-trader-hub',
                'data' => $request->input(),
                'headers' => $request->header(),
                'data_model' => 'vehicle',
                'reference' => $vehicle?->vrm_condensed,
            ]);

        $this->dispatch(new HandleAutoTraderHubNotification($request->input(), $apiNotification));

        return response([
            'status' => 'received'
        ]);
    }
}
