<?php

namespace App\Http\Requests;

use App\Rules\HasNoDuplicateFeatures;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Rules\IsSlugRule;
use Mtc\MercuryDataModels\SeoData;

class UpdateVehicleOfferRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'seo.title' => [
                'nullable',
                'min:' . SeoData::TITLE_MIN_LENGTH,
                'max:' . SeoData::TITLE_MAX_LENGTH,
            ],
            'seo.description' => [
                'nullable',
                'min:' . SeoData::DESCRIPTION_MIN_LENGTH,
                'max:' . SeoData::DESCRIPTION_MAX_LENGTH,
            ],
            'seo.slug' => [
                'nullable',
                new IsSlugRule(),
                'unique:vehicle_offers,slug,' . ($this->vehicle_offer->id ?? 0)
            ],
            'derivative' => [
                'sometimes',
                'max:' . SeoData::TITLE_MAX_LENGTH,
            ],
            'make_id' => [
                'nullable',
                'numeric',
            ],
            'model_id' => [
                'nullable',
                'numeric',
            ],
            'form_id' => [
                'nullable',
                'numeric',
            ],
            'media' => [
                'array'
            ],
            'media.*' => [
                'numeric',
                'exists:media,id'
            ],
            'features' => [
                new HasNoDuplicateFeatures()
            ],
            'featured' => [
                'required',
                'boolean'
            ],
            'published' => [
                'required',
                'boolean'
            ],
            'published_at' => [
                'nullable',
                'date',
            ],
            'unpublished_at' => [
                'nullable',
                'date',
            ],
            'price' => [
                'nullable',
                'numeric'
            ],
            'engine_size_cc' => [
                'nullable',
                'numeric'
            ],
            'deposit' => [
                'nullable',
                'numeric'
            ],
            'battery_range' => [
                'nullable',
                'numeric'
            ],
            'battery_capacity_kwh' => [
                'nullable',
                'numeric'
            ],
            'full_price' => [
                'nullable',
                'numeric',
            ],
            'battery_usable_capacity_kwh' => [
                'nullable',
                'numeric'
            ],
            'battery_charge_time' => [
                'nullable',
                'numeric'
            ],
            'battery_quick_charge_time' => [
                'nullable',
                'numeric'
            ],
            'mpg' => [
                'nullable',
                'numeric'
            ],
            'co2' => [
                'nullable',
                'numeric'
            ],
            'battery_quick_charge_level' => [
                'nullable',
                'numeric'
            ],
            'seo.jsonSchema' => 'json',
            'finance.first_monthly' => [
                'nullable',
                'numeric',
            ],
            'finance.monthly_payment' => [
                'nullable',
                'numeric',
            ],
            'finance.final_payment' => [
                'nullable',
                'numeric',
            ],
            'finance.full_price' => [
                'nullable',
                'numeric',
            ],
            'finance.deposit' => [
                'nullable',
                'numeric',
            ],
            'finance.total_amount' => [
                'nullable',
                'numeric',
            ],
            'finance.total_credit_amount' => [
                'nullable',
                'numeric',
            ],
            'finance.apr' => [
                'nullable',
                'numeric',
            ],
            'finance.interest_rate' => [
                'nullable',
                'numeric',
            ],
            'finance.number_of_months' => [
                'nullable',
                'numeric',
            ],
            'variant' => 'sometimes',
            'variant_type' => 'sometimes',
        ];
    }

    public function attributes()
    {
        return [
            'seo.jsonSchema' => 'JSON schema',
            'seo.slug' => 'slug',
            'seo.title' => 'SEO page title',
            'seo.description' => 'SEO page description',
        ];
    }
}
