<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarAndDrivingReviewSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Type',
                'config_key' => 'app-content-car-and-driving-sync-type',
                'type' => 'string',
                'value' => 'all',
                'description' => 'Choose the sync type',
                'choices' => [
                    ['value' => 'all', 'name' => 'All'],
                    ['value' => 'used', 'name' => 'Used'],
                    ['value' => 'new',  'name' => 'New'],
                ],
                'order' => 1,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Sync Images',
                'config_key' => 'app-content-car-and-driving-should-sync-images',
                'type' => 'boolean',
                'value' => false
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Sync Videos',
                'config_key' => 'app-content-car-and-driving-should-sync-videos',
                'type' => 'boolean',
                'value' => false
            ],
        ];
    }
}
