<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\ContentManager\Models\Template;

class PageTypeDefaultTemplateSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->call(PageTypeSettingSeeder::class);
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Blog',
                'name' => 'Blog article default template',
                'config_key' => 'app-content-blog-default-template',
                'type' => 'text',
                'value' => Template::query()->where('slug', 'news-article')->first()?->id,
                'description' => 'Select template which should be set as default when creating blog articles',
                'order' => 2,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'News',
                'name' => 'News article default template',
                'config_key' => 'app-content-news-default-template',
                'type' => 'text',
                'value' => Template::query()->where('slug', 'news-article')->first()?->id,
                'description' => 'Select template which should be set as default when creating news articles',
                'order' => 4,
            ],
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Versioning',
                'name' => 'Enable content versioning on content pages',
                'config_key' => 'pages-versioning-enabled',
                'type' => 'boolean',
                'value' => Settings::get('pages-versioning-enabled'),
                'description' => 'Stores previous versions of content for content pages, '
                    . ' allows review/collaboration/approval of content',
                'order' => 11,
            ],
        ];
    }
}
