<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Jobs\EasiChatExportJob;
use App\Jobs\ExportToSalesChannelsJob;
use App\Modules\SalesChannels\EasiChat;
use Illuminate\Support\Facades\Queue;
use Tests\TenantTestCase;

class ExportToSalesChannelsTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testIndex()
    {
        Queue::fake();
        Settings::update('sales-channels-easichat-enabled', true);
        (new ExportToSalesChannelsJob(new EasiChat()))->handle();

        Queue::assertPushed(EasiChatExportJob::class);
    }
}
