<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarAndDrivingImageOverwriteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => 'Car and Driving',
                'name' => 'Minimum Images for Overwrite',
                'config_key' => 'app-content-car-and-driving-image-overwrite-threshold',
                'description' => 'If a vehicle has fewer than this number of images, Car and Driving images will overwrite.',
                'type' => 'integer',
                'value' => 0,
            ],
        ];
    }
}
