<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterOptionActiveScopeSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Use active scope for available filter options',
                'config_key' => 'filter-options-use-active-scope',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Use the filter target model active scope (if available) when retrieving filter options.',
            ]
        ];
    }
}
