<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Mtc\MercuryDataModels\Vehicle;

class StockHasFinanceExamples extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::DEVELOPER;
    }

    public function key(): string
    {
        return 'stock_has_finance';
    }

    public function handle(): bool
    {
        $stock = Vehicle::query()
                ->whereDoesntHave('financeExamples')
                ->active()
                ->count();
        if ($stock > 0) {
            $this->failure_reason = __('go-live.errors.stock-missing-finance-examples', [
                'count' => $stock,
                'total' => Vehicle::query()
                    ->active()
                    ->count()
            ]);
            return false;
        }
        return true;
    }
}
