<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateImportCondition extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'active' => [
                'nullable',
                'present',
                'boolean',
            ],
            'do_not_publish' => [
                'nullable',
                'present',
                'boolean',
            ],
            'rules' => 'array',
            'rules.*.field' => [
                'required'
            ],
            'rules.*.condition' => [
                'required'
            ],
        ];
    }
}
