<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\Colour;
use Mtc\MercuryDataModels\Vehicle;

class ColourMapResource extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'colours' => Colour::query()
                ->orderBy('colour')
                ->with('mappedColours')
                ->get()
                ->each(fn(Colour $colour) => $colour->subColours = $colour->mappedColours->map(fn($subColour) => [
                    'name' => $subColour->sub_colour,
                ]))
                ->each(fn(Colour $colour) => $colour->setHidden(['created_at', 'updated_at', 'mappedColours'])),
            'subColours' => Vehicle::query()
                ->whereDoesntHave('colourMap')
                ->distinct()
                ->select('colour')
                ->get()
                ->filter(fn($entry) => $entry->colour)
                ->map(fn($entry) => [
                    'name' => $entry->colour,
                ])
                ->values()
        ];
    }
}
