<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Http\Resources\MediaEntryResource;
use Mtc\MercuryDataModels\CarConfiguratorExtra;
use Mtc\MercuryDataModels\CarConfiguratorPackage;

class ConfiguratorPackageView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->load('mediaUses.media');
        $resource = $this->resource->toArray();
        $resource['media'] = $this->resource->mediaUses->pluck('media_id');
        $resource['media_uses'] = $this->resource->mediaUses
            ->map(fn(MediaUse $mediaUse) => new MediaEntryResource($mediaUse));
        return $resource;
    }
}
