<?php

namespace Database\Seeders\Global;

use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Illuminate\Database\Seeder;

class OpelGrandlandSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run(): void
    {
        $make = VehicleMake::query()->where('slug', 'opel')->first();

        if (empty($make)) {
            return;
        }

        $model_name = 'Grandland';

        VehicleModel::query()->updateOrCreate([
            'make_id' => $make->id,
            'slug' => strtolower($model_name),
            'name' => $model_name,
            'keyloop_id' => strtoupper($model_name),
            'type' => 'car',
        ]);
    }
}
