<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AutosOnShowSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        $description = '<a href="https://www.autosonshow.com/" target="_blank">AutoOnShow</a> integration. '
            . ' - retrieve images from AutosOnShow, handles notification when images have been updated/added.'
            . 'When enabled, will grant access to URL for handling images:<br/>'
            . route('tenant.notifications.autos-on-show', tenant('id'))
            . ' to receive and store images from AutosOnShow';
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'AutosOnShow',
                'name' => 'Enabled',
                'config_key' => 'image-sync-autos-on-show-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => $description
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'AutosOnShow',
                'name' => 'Client ID',
                'config_key' => 'image-sync-autos-on-show-client_id',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.image-sync-autos-on-show-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Image Synchronization',
                'group' => 'AutosOnShow',
                'name' => 'Client Secret',
                'config_key' => 'image-sync-autos-on-show-client_secret',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.image-sync-autos-on-show-enabled,true"
                ]
            ],
        ];
    }
}
