<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\MercuryDataModels\GlobalContent;

class EmailConfirmationContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (ContentElement::query()->where('slug', 'email-content')->exists()) {
            return;
        }

        $element = $this->element();;
        $this->global($element);;
    }

    private function element()
    {
        $data = [
            'title' => 'Customer email notification content',
            'slug' => 'email-content',
            'icon' => 'text',
            'category' => 'navigation',
            'fields' => [
                [
                    'field_type' => 'editor',
                    'name' => 'Content',
                    'slug' => 'content',
                    'data' => [
                        "nestable" => false,
                        "fieldId" => "text",
                        "componentName" => "TextField",
                        "component" => "EditableContentTextField",
                        'icon' => 'text',
                    ],
                ],
                [
                    'field_type' => 'editor',
                    'name' => 'Footer',
                    'slug' => 'footer',
                    'data' => [
                        "nestable" => false,
                        "fieldId" => "text",
                        "componentName" => "TextField",
                        "component" => "EditableContentTextField",
                        'icon' => 'text',
                    ],
                ],
            ]
        ];
        $element = ContentElement::query()->create($data);
        collect($data['fields'])
            ->each(fn($field) => $element->fields()->create($field));
        return $element;
    }

    private function global($enquiryEmail)
    {
        $data = [
            'name' => 'Customer Enquiry Autoresponder',
            'slug' => 'enquiry-autoresponder-email-content',
            'element_id' => $enquiryEmail?->id,
            'content' => [
                [
                    'id' => $enquiryEmail->fields()->where('slug', 'content')->first()?->id,
                    'slug' => 'content',
                    'content' => ''
                ],
                [
                    'id' => $enquiryEmail->fields()->where('slug', 'footer')->first()?->id,
                    'slug' => 'footer',
                    'content' => ''
                ]
            ],
        ];
        GlobalContent::query()->create($data);
    }
}
