 @extends('crm::emails.windsor.layout', [
    'subject' => $enquiry->subject ?? 'Thank you for your enquiry',
    'site_name' => $site_name,
    'site_logo' => $site_logo,
    'site_url' => $site_url,
    'colours' => $colours,
])

@php
$finance_url = \App\Facades\Site::url('/finance') . '?' . http_build_query([
        'ImageUrl'  => $reservation?->vehicle?->getPreviewImage('900x675'),
        'Make'  => $reservation?->vehicle?->make?->name,
        'Model'  => $reservation?->vehicle?->model?->name,
        'Derivative'  => $reservation?->vehicle?->derivative,
        'Registration' => $reservation?->vehicle?->registration_number,
        'Colour' => $reservation?->vehicle?->colour,
        'Mileage' => $reservation?->vehicle?->odometer_mi,
        'FuelType' => $reservation?->vehicle?->fuelType?->name,
        'Transmission' => $reservation?->vehicle?->transmission?->name,
        'Year' =>$reservation?->vehicle?->manufacture_year,
        'RetailValue' => $reservation?->vehicle?->price,
    ]);

    $location = $reservation?->vehicle?->dealership?->name ?? null;

@endphp

@section('content')
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" width="100%">
                            <tr>
                                <td background="{{ config('app.url') . '/api/assets/windsor/valuation-background-image.png' }}" bgcolor="#20292E" valign="bottom" style="border-radius: 10px 10px 0px 0px;" height="175">
                                    <!--[if gte mso 9]>
                                            <v:rect xmlns:v="urn:schemas-microsoft-com:vml" fill="true" stroke="false" style="mso-width-percent:1000; height:175px;">
                                                <v:fill type="tile" src="{{ config('app.url') . '/api/assets/windsor/valuation-background-image.png' }}" color="#20292E" />
                                                <v:textbox style="mso-fit-shape-to-text:true" inset="0,0,0,0">
                                            <![endif]-->
                                    <div>
                                        <table cellpadding="40" cellspacing="0" border="0" width="100%">
                                            <tr>
                                                <td valign="top" align="left">
                                                    <p style="color:#FFFFFF; margin:0; font-size:40px; font-weight:700; letter-spacing:-0.8px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">Your reservation</p>
                                                </td>
                                                <td valign="top" align="right">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    <!--[if gte mso 9]>
                                    </v:textbox>
                                    </v:rect>
                                    <![endif]-->
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                            </tr>
                            <tr>
                                <td valign="top">
                                    <table cellpadding="0" cellspacing="0" border="0" width="100%">
                                        <tr>
                                            <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                            <td valign="top">
                                                <table cellpadding="0" cellspacing="0" border="0" width="100%" bgcolor="#F2F5F7" style="background-color:#F2F5F7;">
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Vehicle
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $reservation->vehicle?->make?->name }}
                                                                {{ $reservation->vehicle?->model?->name }}
                                                                {{ $reservation->vehicle?->derivative }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top" height="10"></td>
                                                    </tr>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Mileage
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ number_format($reservation->vehicle?->odometer_mi) }} miles
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <td valign="top" height="10"></td>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Registration
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $reservation->vehicle?->registration_number }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <td valign="top" height="10"></td>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Price
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                &pound;{{ number_format($reservation->vehicle?->price) }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <td valign="top" height="10"></td>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Vehicle Location
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $location ?? 'N/A' }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <td valign="top" height="10"></td>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Reserved By
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $reservation->name }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <td valign="top" height="10"></td>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Contact email
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $reservation->email }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <td valign="top" height="10"></td>
                                                    <tr>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:400; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                Contact phone number
                                                            </p>
                                                        </td>
                                                        <td valign="top">
                                                            <p style="color:#20292E; margin:0; font-size:18px; font-weight:700; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">
                                                                {{ $reservation->contact_number }}
                                                            </p>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                            <td valign="top" width="40" bgcolor="#F2F5F7" style="background-color:#F2F5F7;"></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td valign="top" height="20" bgcolor="#F2F5F7" style="background-color:#F2F5F7;border-radius:0px 0px 10px 10px;"></td>
                            </tr>
                        </table>
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
                <tr>
                    <td valign="top" height="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    <!-- CONTENT AREA -->
    <tr>
        <td valign="top">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td valign="top" width="50"></td>
                    <td valign="top">
                        {!! str_replace(
                            [
                                '[finance-button]',
                                '<p>',
                                '<h1>',
                                '<h2>',
                                '<h3>',
                                '<td>',
                            ],
                            [
                                '<table cellpadding="0" cellspacing="0" border="0" align="left" width="100%"><tr><td valign="top">
                                <table cellpadding="0" cellspacing="0" border="0" align="left" width="400">
                                    <tr>
                                        <td align="center" style="border-radius: 5px; background-color: #FF981F;">
                                            <a rel="noopener" href="' . $finance_url . '" target="_blank" style="font-size: 22px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif; color: #FFFFFF; font-weight: 700; text-decoration: none;border-radius: 5px; padding: 14px 18px; border: 1px solid #FF981F; display: inline-block;">
                                                <img class="imageFix" src="' . config('app.url') . '/api/assets/windsor/icons/shield.png" alt="Shield" title="Shield" width="19" height="19" style="display:inline-block; outline:none; text-decoration:none; -ms-interpolation-mode: bicubic; border:none;" /> Check Finance <br />
                                            </a>
                                        </td>
                                    </tr>
                                </table></td></tr><tr>
    <td height="40"></td>
</tr></table>',
                                '<p style="color:#20292E; margin:0 0 20px; font-size:18px; font-weight:400; line-height:26px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h1 style="color:#FFFFFF !important; margin:0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h2 style="color:#20292E; margin:0 0 10px; font-size:32px; line-height:36px; font-weight:700; letter-spacing:-0.64px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<h3 style="color:#20292E; margin:0 0 10px; font-size:24px; line-height:28px; font-weight:700; letter-spacing:-0.48px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                                '<td valign="top" width="20">',
                            ],
                        $content) !!}
                    </td>
                    <td valign="top" width="50"></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td valign="top" height="50"></td>
    </tr>
    <!-- END OF CONTENT AREA -->
@endsection


@section('footer')
    <tr>
        <td colspan="2" align="center" class="smallText">
            {!! str_replace(
                [
                    '<p>',
                    '<h1>',
                    '<h2>',
                    '<h3>',
                    '<h4>',
                    '<h5>',
                    '<h6>',
                    '<ul>',
                    '<li>',
                    '<ol>',
                    '<td>',
                ],
                [
                    '<p style="color:#20292E; margin:0; font-size:12px; font-weight:500; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h1 style="color:#FFFFFF !important; margin:0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h2 style="color:#20292E; margin:0 0 10px; font-size:32px; line-height:36px; font-weight:700; letter-spacing:-0.64px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h3 style="color:#20292E; margin:0 0 10px; font-size:24px; line-height:28px; font-weight:700; letter-spacing:-0.48px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                    '<h4>',
                    '<h5>',
                    '<h6>',
                    '<ul>',
                    '<li>',
                    '<ol>',
                    '<td valign="top" width="20">',
                ],
            $footer) !!}
        </td>
    </tr>
@endsection
