<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\Crm\Models\EnquiryStatus;

class EnquiryStatusRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $enquiryStatus = EnquiryStatus::query()->create($entry);

        return $enquiryStatus->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !EnquiryStatus::query()
            ->where('name', $entry['name'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return EnquiryStatus::query()
            ->select([
                'name',
                'is_final',
                'is_initial',
            ])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $errors = [];
        if (EnquiryStatus::query()->where('name', $dataEntry['name'])->exists()) {
            $errors[] = __('validation.import_name_taken', ['name' => $dataEntry['name']]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
