<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use JetBrains\PhpStorm\ArrayShape;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class UpdateReplacementRequest extends FormRequest
{
    use CentralConnection;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check() && Auth::user()->hasRole(['mtc', 'Administrator']);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    #[ArrayShape(['original' => "string[]", 'replacement' => "string[]", 'type' => "string[]"])] public function rules()
    {
        return [
            'original' => [
                'required',
            ],
            'replacement' => [
                'required',
            ],
            'type' => [
                '',
            ]
        ];
    }
}
