<?php

namespace App\Modules\Stock;

use App\Contracts\AddsDealershipFields;
use App\Contracts\StockProvider;
use App\Facades\Settings;
use App\Modules\Stock\CustomEndpoint\EMCImport;
use App\Modules\Stock\CustomEndpoint\PCKReservedFeed;

class CustomEndpoint implements StockProvider, AddsDealershipFields
{
    /**
     * Check if enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return Settings::get('stock-endpoint-enabled') ?? false;
    }

    /**
     * Name of the integration
     *
     * @return string
     */
    public function name(): string
    {
        return 'Custom Feed';
    }

    /**
     * Perform a scheduled import task
     *
     * @return void
     */
    public function runScheduledImport(bool $fullSync = true): void
    {
        match (Settings::get('stock-endpoint-provider')) {
            'emc' => (new EMCImport())->handle(),
            'pck' => (new PCKReservedFeed())->handle(),
            default => null,
        };
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields(): array
    {
        return [
            'custom-feed-location-id' => [
                'type' => 'text',
                'label' => 'Dealership ID on stock feed',
            ],
        ];
    }
}
