<?php

namespace App\Traits;

use App\Facades\Settings;

trait GetsColourSettings
{
    protected function getColourSettings()
    {
        $keys = [
            'app-primary-colour',
            'app-secondary-colour',
            'app-tertiary-colour',
            'app-success-colour',
            'app-error-colour',
            'app-information-colour',
            'app-text-colour',
            'app-subtext-colour',
            'app-layer-dark-colour',
            'app-layer-accent-colour',
            'app-layer-light-colour',
        ];

        $colours = [];

        foreach ($keys as $key) {
            $colours[$key] = Settings::get($key);
        }

        $overrides = [
            'app-text-colour' => 'app-text-colour-override',
            'app-primary-colour' => 'app-primary-colour-override',
        ];

        collect($overrides)->each(function ($override_setting_key, $key_to_override) use (&$colours) {
            if (!empty(Settings::get($override_setting_key))) {
                $colours[$key_to_override] = Settings::get($override_setting_key);
            }
        });

        return $colours;
    }
}
