<?php


use App\Http\Controllers\AssetController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\TaxonomyController;
use App\Http\Controllers\UserController;
use App\Master\Http\Controllers\AllUserController;
use App\Master\Http\Controllers\BillableController;
use App\Master\Http\Controllers\CommandController;
use App\Master\Http\Controllers\ContentSyncController;
use App\Master\Http\Controllers\HealthCheckController;
use App\Master\Http\Controllers\ImpersonateController;
use App\Master\Http\Controllers\InvoiceController;
use App\Master\Http\Controllers\RoleController;
use App\Master\Http\Controllers\SiteController;
use App\Master\Http\Controllers\SiteDomainController;
use App\Master\Http\Controllers\UploadProfilePhotoController;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Stancl\Tenancy\Middleware\InitializeTenancyByRequestData;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', [UserController::class, 'show']);

Route::post('/content-sync/provide-entries', [ContentSyncController::class, 'provideEntries']);
Route::put('/content-sync/perform', [ContentSyncController::class, 'receiveDataFromRemote']);

Route::middleware(['throttle:site-domains'])->group(function () {
    Route::get('/site-domains/v2', [SiteDomainController::class, 'domainsWithPorts']);
    Route::get('/site-domains', [SiteDomainController::class, 'listDomains']);
});

Route::middleware('auth:sanctum')->group(function (Router $router) {
    $router->post('/user/profile-photo', [UploadProfilePhotoController::class, 'update']);
    $router->get('/user', [UserController::class, 'show'])->name('users.show');
    $router->post('/user/set-site', [UserController::class, 'setSite'])->name('users.set-site');
    $router->get('sites/queues', [SiteController::class, 'queueLengths'])->name('sites.queue-lengths');
    $router->get('get-roles', [SiteController::class, 'roles'])->name('sites.roles');
    $router->post('stop-impersonate', [ImpersonateController::class, 'stopImpersonate'])->name('stop-impersonate');


    $router->middleware([
        'role:' . config('mtc_login.mtc_user_role')
    ])->group(function (Router $router) {
        $router->get('trigger-command', [CommandController::class, 'index']);
        $router->post('trigger-command', [CommandController::class, 'store']);

        $router->post('impersonate-user/{user}', [ImpersonateController::class, 'impersonate'])->name('impersonate');
        $router->put('sites/{site}/trigger-action', [SiteController::class, 'triggerAction'])->name('sites.trigger-action');
        $router->get('sites/{site}/billing', [SiteController::class, 'billing'])->name('sites.get-billing');
        $router->put('sites/{site}/billing', [SiteController::class, 'updateBilling'])->name('sites.updateBilling');
        $router->post('sites/{site}/invite', [SiteController::class, 'invite'])->name('sites.invite-user');
        $router->post('sites/{site}/remove-user', [SiteController::class, 'removeUser'])->name('sites.remove-user');
        $router->post('sites/{site}/update-user', [SiteController::class, 'updateUserRole'])->name('sites.update-user');
        $router->post('sites/{site}/mark-live', [SiteController::class, 'markLive'])->name('sites.mark-live');
        $router->post('sites/{site}/suspend', [SiteController::class, 'suspendSite'])->name('sites.suspend');
        $router->post('sites/{site}/unsuspend', [SiteController::class, 'unsuspendSite'])->name('sites.unsuspend');
        $router->post('sites/integrations', [SiteController::class, 'integrations'])->name('sites.integrations');
        $router->resource('sites', SiteController::class)->only(['index', 'store', 'destroy']);

        $router->put('all-users/{user}/require-password-change', [AllUserController::class, 'requirePasswordChange'])
            ->name('user-management.require-password-change');
        $router->put('all-users/{user}/reset-password', [AllUserController::class, 'resetPassword'])
            ->name('user-management.reset-password');
        $router->put('all-users/{user}/reset-2fa', [AllUserController::class, 'reset2FactorAuth'])
            ->name('user-management.reset-two-factor');
        $router->resource('all-users', AllUserController::class)->only(['index', 'show', 'destroy']);
        $router->apiResource('roles', RoleController::class);

        $router->get('taxonomies', [TaxonomyController::class, 'index']);
        $router->get('taxonomies/unmapped', [TaxonomyController::class, 'unmapped']);
        $router->post('taxonomies/from-unmapped', [TaxonomyController::class, 'storeUnmapped']);
        $router->get('taxonomies/mapped', [TaxonomyController::class, 'mapped']);
        $router->post('taxonomies/clear-mapped/{taxonomyMap}', [TaxonomyController::class, 'clearMapped']);
        $router->get('taxonomies/{type}/{id}', [TaxonomyController::class, 'showEntry']);
        $router->put('taxonomies/{type}/{id}', [TaxonomyController::class, 'updateEntry']);
        $router->delete('taxonomies/{type}/{id}', [TaxonomyController::class, 'destroy']);
        $router->get('taxonomies/{type}', [TaxonomyController::class, 'show']);
        $router->post('taxonomies/{type}', [TaxonomyController::class, 'store']);
        $router->put('taxonomies/{map}', [TaxonomyController::class, 'update']);

        $router->resource('invoices', InvoiceController::class)->only(['index', 'show']);
        $router->resource('billables', BillableController::class)->only(['index']);

        $router->post('/assets/global', [AssetController::class, 'globalStore']);

        $router->post('/content-sync/get-entries', [ContentSyncController::class, 'getRemoteEntries']);
        $router->put('/content-sync/{sync}', [ContentSyncController::class, 'update']);
        $router->put('/content-sync', [ContentSyncController::class, 'run']);
        $router->resource('/content-sync', ContentSyncController::class)->only(['index', 'store', 'show']);
    });

    $router->post('/content/media', [MediaController::class, 'store'])
        ->middleware([
            InitializeTenancyByRequestData::class,
            implode(',', config('pages.route_middleware.media')),
        ])
        ->name('content.media.store');
});
