<?php

namespace App\Http\Requests;

use App\Facades\Settings;
use Illuminate\Foundation\Http\FormRequest;

class AutoTraderHubNotification extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->hasHeader('authorization')
            && Settings::get('auto-trader-hub-token') === $this->header('authorization');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            //
        ];
    }
}
