<?php

namespace App\Imports;

use App\TaxonomyMap;
use App\Traits\MapsTaxonomies;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class TaxonomyMapImport implements ToModel, WithHeadingRow
{
    use MapsTaxonomies;

    public function __construct(protected $type, protected $provider)
    {
        //
    }

    public function model(array $row)
    {
        if($this->type == TaxonomyMap::MODEL){
            $makeId = $this->getMappedTaxonomy(
                TaxonomyMap::MAKE,
                trim($row['make']),
                [
                    $this->provider.'_id' => $row['make_id']
                ]
            );

            $this->getMappedTaxonomy(
                $this->type,
                trim($row['model']),
                [
                    $this->provider.'_id' => $row['model_id']
                ],
                $makeId
            );
        } else {
            $this->getMappedTaxonomy(
                $this->type,
                trim($row['name']),
                [
                    $this->provider.'_id' => $row['id']
                ]
            );
        }
    }

    protected function getProviderName(): string
    {
        return $this->provider;
    }

    /**
     * Get the array of details to be saved.
     * Can be overridden to define the array to be saved.
     *
     * @param array|null $record
     * @return array
     */
    protected function getDetailsForTaxonomyMap(?array $record): array
    {
        return $record;
    }
}
