<?php

namespace App\Jobs;

use App\Exports\EbayMotorsExport;
use App\Exports\VolvoSelectExport;
use App\IntegrationRepository;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Maatwebsite\Excel\Facades\Excel;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Tenant;

class VolvoSelectExportJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->onQueue('export');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $filename = config('filesystems.disks.volvo-select-export.filename');

        $export = new VolvoSelectExport();

        /*Excel::store(
            $export,
            $filename,
            'ebay-motors-export'
        );*/

        try {
            Storage::disk('local')->put($filename, $export->generateXml());
            Storage::disk('local')->exists($filename);
        } catch (Exception $exception) {
            dump($exception->getMessage());
            dd($exception->getTraceAsString());
            Log::warning('Volvo select export error: ' . $exception->getMessage());
        }
    }
}
