<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\EbayMotorsExportJob;
use App\Jobs\VolvoSelectExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class VolvoSelect implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-volvo-select-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.volvo_select');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        $this->dispatch(new VolvoSelectExportJob());
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'volvo-select-dealer-id' => [
                'type' => 'text',
                'validation' => [
                    'required',
                ],
                'label' => 'Feed ID on Volvocars'
            ],
        ];
    }
}
