<?php

$isS3 = env('FILE_STORAGE_DRIVER', 'local') === 's3';
$staging_ftp = env('APP_ENV') === 'staging' && empty(env('LIVE_SALES_CHANNEL_EXPORT_HOSTS'));
return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DRIVER', 'local'),
    'default_media' => env('FILESYSTEM_MEDIA_DRIVER', 'public'),
    'default_media_original' => env('FILESYSTEM_MEDIA_DRIVER', 'public'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been setup for each driver as an example of the required options.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL') . '/storage',
            'visibility' => 'public',
        ],

        's3' => [
            'driver' => 's3',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'url' => env('AWS_URL'),
            'endpoint' => env('AWS_ENDPOINT'),
            'use_path_style_endpoint' => env('AWS_USE_PATH_STYLE_ENDPOINT', false),
        ],

        'file-storage' => [
            'driver' => env('FILE_STORAGE_DRIVER', 'local'),
            'key' => env('DO_ACCESS_KEY_ID'),
            'secret' => env('DO_SECRET_ACCESS_KEY'),
            'region' => env('DO_DEFAULT_REGION'),
            'bucket' => env('DO_BUCKET'),
            'url' => $isS3 ? env('DO_URL') : env('APP_URL') . '/storage',
            'endpoint' => env('DO_ENDPOINT'),
            'cdn_endpoint' => env('DO_CDN_ENDPOINT'),
            'use_path_style_endpoint' => env('DO_USE_PATH_STYLE_ENDPOINT', false),
            ($isS3 ? 'folder' : 'root') => ($isS3 ? 'file-storage' : storage_path('app/public')),
        ],


        'media' => [
            'driver' => env('FILE_STORAGE_DRIVER', 'local'),
            'key' => env('DO_ACCESS_KEY_ID'),
            'secret' => env('DO_SECRET_ACCESS_KEY'),
            'region' => env('DO_DEFAULT_REGION'),
            'bucket' => env('DO_BUCKET'),
            'url' => $isS3 ? env('DO_URL') : env('APP_URL') . '/storage/media',
            'endpoint' => env('DO_ENDPOINT'),
            'cdn_endpoint' => env('DO_CDN_ENDPOINT'),
            'use_path_style_endpoint' => env('DO_USE_PATH_STYLE_ENDPOINT', false),
            ($isS3 ? 'folder' : 'root') => ($isS3 ? 'media' : storage_path('app/public/media')),
        ],

        'content-icons' => [
            'driver' => env('FILE_STORAGE_DRIVER', 'local'),
            'key' => env('DO_ACCESS_KEY_ID'),
            'secret' => env('DO_SECRET_ACCESS_KEY'),
            'region' => env('DO_DEFAULT_REGION'),
            'bucket' => env('DO_BUCKET'),
            'url' => $isS3 ? env('DO_URL') : env('APP_URL') . '/storage/icons',
            'endpoint' => env('DO_ENDPOINT'),
            'cdn_endpoint' => env('DO_CDN_ENDPOINT'),
            'use_path_style_endpoint' => env('DO_USE_PATH_STYLE_ENDPOINT', false),
            ($isS3 ? 'folder' : 'root') => ($isS3 ? 'assets' : storage_path('app/public/assets')),
        ],

        'silver-bullet' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'ftp.mystorefront.co.uk',
            'port' => $staging_ftp ? null : 32323,
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],

        'car-guru-export' => [
            'driver' => 'ftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'ftp.cargurus.co.uk',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'car-wow-export' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'files.carwow.com',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'moto-novo-export' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'stockftp.ivendi.com',
            'port' => $staging_ftp ? null : 26222,
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'car-snip-export' => [
            'driver' => 'ftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'ftp.carsnip.com',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'aa-cars-export' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'feeds.vcars.co.uk',
            'port' => $staging_ftp ? null : 2020,
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'inventory-export' => [
            'driver' => 'ftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'ftp.inventorycc.com',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'cars-ireland-export' => [
            'driver' => 'ftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'ftp.carsireland.ie',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'hey-car-export' => [
            'port' => $staging_ftp ? null : 22,
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'file-transfer.heycar.co.uk',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'motors-co-uk-export' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'datafeeds.autoedit.co.uk',
            'port' => $staging_ftp ? null : 22,
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'ebay-motors-export' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp' : 'sftpgo.feedonomics.com',
            'root' => $staging_ftp ? '/files' : '/incoming',
            'username' => env('EBAY_MOTORS_FEED_SFTP_USERNAME'),
            'password' => env('EBAY_MOTORS_FEED_SFTP_PASSWORD'),
            'filename' => env('EBAY_MOTORS_FEED_FILENAME'),
            'ssl' => $staging_ftp ? true : null,
        ],
        'volvo-select-export' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'host' => $staging_ftp ? 'ftp' : 'sftpgo.feedonomics.com',
            'root' => $staging_ftp ? '/files' : '/incoming',
            'username' => env('VOLVO_SELECT_FEED_SFTP_USERNAME'),
            'password' => env('VOLVO_SELECT_FEED_SFTP_PASSWORD'),
            'filename' => env('VOLVO_SELECT_FEED_FILENAME'),
            'ssl' => $staging_ftp ? true : null,
        ],
        'auto-trader-export' => [
            'driver' => $staging_ftp ? 'ftp' : 'sftp',
            'port' => $staging_ftp ? null : 22,
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'datafeeds.autotrader.co.uk',
            'username' => env('AUTO_TRADER_FEED_FTP_USERNAME'),
            'password' => env('AUTO_TRADER_FEED_FTP_PASSWORD'),
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'autoloadit-images-import' => [
            'driver' => 'ftp',
            'host' => env('AUTOLOADIT_IMAGE_FTP_HOST'),
            'root' => $staging_ftp ? '/files' : '/agt',
            'username' => env('AUTOLOADIT_IMAGE_FTP_USERNAME'),
            'password' => env('AUTOLOADIT_IMAGE_FTP_PASSWORD'),
        ],
        'autonomy-ftp' => [
            'driver' => 'ftp',
            'host' => 'ftp.getautonomy.co.uk',
            'ssl' => true,
        ],
        'carzone-export' => [
            'driver' => 'ftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'carzone-storage.mtcserver.com',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
        'phyron-export' => [
            'driver' => 'ftp',
            'host' => 'ftp.getautonomy.co.uk',
            'root' => '/files',
            'username' => env('PHYRON_FEED_FTP_USERNAME'),
            'password' => env('PHYRON_FEED_FTP_PASSWORD'),
            'ssl' => true,
        ],
        'motors-sftp' => [
            'driver' => 'ftp',
            'host' => $staging_ftp ? 'ftp.getautonomy.co.uk' : 'sftpgo.feedonomics.com',
            'ssl' => $staging_ftp ? true : null,
            'root' => $staging_ftp ? '/files' : null,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Symbolic Links
    |--------------------------------------------------------------------------
    |
    | Here you may configure the symbolic links that will be created when the
    | `storage:link` Artisan command is executed. The array keys should be
    | the locations of the links and the values should be their targets.
    |
    */

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],

];
