<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleFilterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Make',
                'config_key' => 'automotive-vehicle-filters-make',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Model',
                'config_key' => 'automotive-vehicle-filters-model',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Body Style',
                'config_key' => 'automotive-vehicle-filters-body_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Price',
                'config_key' => 'automotive-vehicle-filters-price',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Manufacture Year',
                'config_key' => 'automotive-vehicle-filters-age',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Colour',
                'config_key' => 'automotive-vehicle-filters-colour',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Door Count',
                'config_key' => 'automotive-vehicle-filters-door_count',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Engine Size',
                'config_key' => 'automotive-vehicle-filters-engine_size',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Fuel Type',
                'config_key' => 'automotive-vehicle-filters-fuel_type',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Transmission Type',
                'config_key' => 'automotive-vehicle-filters-transmission',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Location',
                'config_key' => 'automotive-vehicle-filters-location',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Mileage',
                'config_key' => 'automotive-vehicle-filters-mileage',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Seat Count',
                'config_key' => 'automotive-vehicle-filters-seats',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Filter Search Term',
                'config_key' => 'automotive-vehicle-filters-search',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'New Additions',
                'config_key' => 'automotive-vehicle-sorting-latest',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Price (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-price-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Price (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-price-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Monthly Price (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-monthly-price-desc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Monthly Price (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-monthly-price-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Mileage (High > Low)',
                'config_key' => 'automotive-vehicle-sorting-mileage-desc',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Mileage (Low > High)',
                'config_key' => 'automotive-vehicle-sorting-mileage-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Manufacture Year (New > Old)',
                'config_key' => 'automotive-vehicle-sorting-age-asc',
                'type' => 'boolean',
                'value' => true,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Manufacture Year (Old > New)',
                'config_key' => 'automotive-vehicle-sorting-age-desc',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
