<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VolvoSelectExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Volvo Select',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-volvo-select-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
