<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\Models\Content;

class ClearOrphanPageContent extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'pages:clear-orphan-content';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clears orphaned page_content entries that reference non-existing pages';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Delete orphaned page_content records using a relation query
        $orphanCount = Content::query()
            ->whereDoesntHave('page', function ($query) {
                $query->withTrashed(); // Include soft-deleted pages
            })
            ->delete();

        $this->info("Deleted {$orphanCount} orphan page_content entries.");

        return Command::SUCCESS;
    }
}
