<?php

namespace App\Exports;

use App\Facades\Settings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\MercuryDataModels\Dealership;

class HeyCarDealerExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return Dealership::query()
            ->with([
                'mediaUses.media',
                'dealership',
                'make',
                'model',
                'transmission',
                'fuelType',
                'bodyStyle',
                'specs',
            ])
            ->exportable()
            ->get()
            ->map(function (Dealership $dealership) {
                return [
                    'dealer_id' => $dealership->data['hey-car-dealer-id'] ?? null,
                    'name' => $dealership->name ?? null,
                    'franchise' => '',
                    'street' => $dealership->address1,
                    'city' => $dealership->city,
                    'county' => $dealership->county,
                    'postcode' => $dealership->postcode,
                    'email' => $dealership->email,
                    'phone' => $dealership->contact_no,
                    'url' => Settings::get('app-url')
                ];
            });
    }

    /**
     * Heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'dealer_id',
            'name',
            'franchise',
            'street',
            'city',
            'county',
            'postcode',
            'email',
            'phone',
            'url',
        ];
    }
}
