<?php

namespace App\Http\Resources;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Http\Request;
use Mtc\MercuryDataModels\Form;

class FormList extends \Mtc\Crm\Http\Resources\FormList
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        if ($this->resource instanceof LengthAwarePaginator) {
            $resource = $this->resource
                ->through(fn(Form $form) => $this->mapRecord($form))
                ->toArray();

            $resource['default_columns'] = [
                'updated',
                'type',
            ];
            return $resource;
        }

        return $this->resource
            ->map(fn(Form $form) => $this->mapRecord($form))
            ->toArray();
    }

    public function mapRecord(Form $form)
    {
        return [

            'id' => $form->id,
            'name' => $form->name,
            'title' => $form->name,
            'active' => (bool)$form->is_active,
            'link' => '/crm/forms/edit/' . $form->id,
            'metaItems' => [
                'updated' => $form->updated_at->diffForHumans(),
                'type' => $form->type?->name,
            ],
        ];
    }
}
