<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AdjustMailSettingRequired extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server host',
                'config_key' => 'mail-smtp-host',
                'type' => 'string',
                'validation_rules' => null,
                'description' => 'Host for mail server that will be sending emails',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server port',
                'config_key' => 'mail-smtp-port',
                'type' => 'int',
                'validation_rules' => null,
                'description' => 'Port for mail server that will be sending emails',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server username',
                'config_key' => 'mail-smtp-username',
                'type' => 'string',
                'validation_rules' => null,
                'description' => 'Username for mail server that will be sending emails',
            ],
            [
                'tab' => 'Site',
                'section' => 'Mail',
                'group' => 'Mail Sending',
                'name' => 'SMTP server password',
                'config_key' => 'mail-smtp-password',
                'type' => 'secret',
                'validation_rules' => null,
                'description' => 'Password for mail server that will be sending emails',
            ],
        ];
    }
}
