<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\MercuryDataModels\SeoData;
use Mtc\MercuryDataModels\SeoRedirect;

class SeoRedirectExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return SeoRedirect::query()
            ->select(['code', 'from', 'to', 'from_domain', 'to_domain', 'has_regex'])
            ->get();
    }

    /**
     * Export file heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'code',
            'from',
            'to',
            'from_domain',
            'to_domain',
            'has_regex',
        ];
    }
}
