<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateOfferTypeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'slug' => 'required',
            'template_id' => [
                'required',
                'numeric',
                'exists:page_templates,id',
            ],
            'parent_id' => [
                'nullable',
                'exists:offer_types,id',
            ],
            'data' => [
                'sometimes',
            ],
        ];
    }
}
