<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Mtc\MercuryDataModels\SeoData;
use Mtc\MercuryDataModels\SeoRedirect;

class SeoRedirectImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {
        if ($this->conflictingRedirect($row)) {
            return;
        }

        SeoRedirect::query()
            ->updateOrCreate([
                'from' => $row['from'],
                'from_domain' => $row['from_domain'] ?? null,
            ], [
                'to' => $row['to'],
                'code' => $row['code'],
                'to_domain' => $row['to_domain'] ?? null,
                'has_regex' => $row['has_regex'] ?? 0
            ]);
    }

    private function conflictingRedirect(array $row): bool
    {
        $redirect_to_itself = $row['from'] === $row['to']
            && ($row['from_domain'] === $row['to_domain'] || empty($row['to_domain']));
        if ($redirect_to_itself) {
            return true;
        }
        return SeoRedirect::query()->where('from', $row['to'])->exists();
    }
}
