<?php

namespace App\Modules\Leasing;

use App\Modules\Leasing\Jobs\OptionCategoryImportJob;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\KeyloopLeaseOptionCategory;

class KeyloopFleetKompactOptionCategoryImporter extends KeyloopFleetKompactImporterBase
{
    protected function filter(Collection $data): bool
    {
        return true;
    }

    protected function prepareForImport(): void
    {
        KeyloopLeaseOptionCategory::query()->update([
            'was_recently_synced' => false,
        ]);
    }

    protected function importItems(Collection $data): void
    {
        $this->dispatch(new OptionCategoryImportJob($data->map(fn ($item) => [
            'option_code' => $item['item-id'],
            'name' => $item['section'],
        ])));
    }
}
