<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Facades\Forms;
use Mtc\Crm\Models\FormQuestion;
use Mtc\Crm\Models\FormSection;
use Mtc\MercuryDataModels\Form;
use Tests\TenantTestCase;
use Tests\TestCase;

class FormRepositoryTest extends TenantTestCase
{
    public function testUpdate()
    {
        $form = Form::factory()->create();
        $section = FormSection::factory()->create(['form_id' => $form->id]);
        $questions = FormQuestion::factory(5)->create(['form_id' => $form->id, 'form_section_id' => $section->id]);
        $result = Forms::update(request()->merge([
            'name' => $form->name,
            'is_active' => true,
            'type_id' => 11,
            'initial_status_id' => 22,
            'initial_assignee' => 123,
            'success_message' => 'lorem ipsum',
            'actions' => [
                'foo' => [
                    'fields' => [
                        'baz' => 'bar'
                    ]
                ]
            ],
            'sections' => [
                [
                    'id' => $section->id,
                    'settings' => [],
                    'name' => 'lorem ipsum',
                    'sections' => [
                        [
                            'id' => 'abc1233',
                            'name' => 'header',
                            'questions' => [
                                [
                                    'id' => $questions->first()->id,
                                    'name' => $questions->first()->name,
                                    'fieldId' => 'test',
                                    'type' => 'test',
                                    'is_active' => 1,
                                    'settings' => [],
                                    'validation' => [],
                                    'description' => '',
                                    'placeholder' => '',
                                    'answer_options' => [],
                                    'data' => [],
                                ]
                            ]
                        ]
                    ]
                ],
                [
                    'id' => 'foo',
                    'settings' => [],
                    'name' => 'lorem ipsum',
                    'sections' => [
                        [
                            'id' => 'abc1233',
                            'name' => 'header',
                            'questions' => [
                                [
                                    'id' => 'foo',
                                    'name' => 'foo',
                                    'fieldId' => 'test',
                                    'type' => 'test',
                                    'is_active' => 1,
                                    'settings' => [],
                                    'validation' => [],
                                    'description' => '',
                                    'placeholder' => '',
                                    'answer_options' => [],
                                    'data' => [],
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ]), $form);

        $form->refresh();

        $this->assertEquals(11, $form->type_id);
        $this->assertEquals(22, $form->initial_status_id);
        $this->assertEquals(123, $form->initial_assignee);
        $this->assertEquals('lorem ipsum', $form->success_message);
        $this->assertEquals(1, $form->is_active);
    }

}
